import React, { useRef } from "react";
import emailjs from "emailjs-com";
import "../style/EnquiryForm.css";

const EnquiryForm = () => {
  const form = useRef();

  const sendEmail = (e) => {
    e.preventDefault();

    console.log({
    user_name: form.current.user_name.value,
    user_email: form.current.user_email.value,
    
    message: form.current.message.value,
  });

    emailjs
      .sendForm(
        "service_udzn4bc",   // e.g. service_123xyz
        "template_g4a5lpp",  // e.g. template_abcd123
        form.current,
        "TFTBjxw-jcfvbry0Q"    // e.g. y0urPubl1cKey
      )
      .then(
        () => {
          alert("✅ Enquiry sent successfully!");
          form.current.reset();
        },
        (error) => {
          console.error(error);
          alert("❌ Failed to send enquiry. Please try again.");
        }
      );
  };

  return (
    <div className="enquiry-container">
      <h2>Enquiry Form</h2>
      <form ref={form} onSubmit={sendEmail} className="enquiry-form">
        <label>Name:</label>
        <input type="text" name="user_name" placeholder="Enter your name" required />

        <label>Email:</label>
        <input type="email" name="user_email" placeholder="Enter your email" required />

         <label>Reference Id:</label>
        <input type="text" name="reference" placeholder="Enter Reference Id" required />

        {/* <label>Subject:</label>
        <input type="text" name="subject" placeholder="Enter subject" required /> */}

        <label>Mobile No:</label>
        <input type="text" name="mobile" placeholder="Enter mobile no" required />

        <label>College:</label>
        <input type="text" name="college" placeholder="Enter college" required />

        <label>Degree:</label>
        <input type="text" name="degree" placeholder="Enter degree" required />

        <label>Topic:</label>
        <input type="text" name="topic" placeholder="Enter topic" required />

        <label>Year:</label>
        <input type="text" name="year" placeholder="Enter year" required />

        <label>Message:</label>
        <textarea name="message" placeholder="Type your message" />

        <button type="submit">Send Enquiry</button>
      </form>
    </div>
  );
};

export default EnquiryForm;
